#ifndef LIBACP_LIBACPSERVER_H_
#define LIBACP_LIBACPSERVER_H_

#include <string.h>
#include <stdint.h>
#include "libacpDef.h"

#ifdef _WIN32
#define LIBACP_EXPORTS extern "C" __declspec(dllexport)
#else
#define LIBACP_EXPORTS extern "C" __attribute__((visibility("default")))
#endif

typedef void* ACPSERVER_HANDLE;  // 服务端句柄handler

/**
 * @brief 初始化acp服务,加载依赖的相关设备信息
 * @prarm szAcpIniFile 加载ACP的配置文件,传入空的话使用默认的配置文件
 * @return :成功返回0,失败返回-1
 */
LIBACP_EXPORTS int libacpserver_init(const char* szAcpIniFile);

/**
 * @brief 创建一个ACP的服务,监听的端口和启动线程数目依赖配置文件 libacp.ini
 * @return :成功返回句柄,否则句柄为空
 */
LIBACP_EXPORTS ACPSERVER_HANDLE libacpserver_create(pfnOnClientConnect connCallBack,
                                                    pfnOnClientDisConnect connDisCallback, void* lpContex);

/**
 * @brief 添加消息的路由
 * @param in: handler libacpserver_init返回的句柄
 * @param in: port 注册消息的路由port
 * @param callback: callback 接收该port号注册到消息路由的回调函数
 * @param lpContex: 用户参数的指针
 * @return :成功返回0 失败返回-1
 */
LIBACP_EXPORTS int libacpserver_addrouter(ACPSERVER_HANDLE handler, uint16_t port, pfnServerMsgRouterCallBack callback,
                                          void* lpContex);

/**
 * @brief 启动ACP的服务
 * @param in: handler libacpserver_init返回的句柄
 * @return :成功返回0 失败返回-1
 */
LIBACP_EXPORTS int libacpserver_start(ACPSERVER_HANDLE handler);

/**
 * @brief 停止ACP服务
 * @param in: handler libacpserver_init返回的句柄
 * @return :成功返回0 失败返回-1
 */
LIBACP_EXPORTS int libacpserver_stop(ACPSERVER_HANDLE handler);

/**
 * @brief  服务端回应客户端数据
 * @param in: conn  ACPCONN_HANDLE的句柄
 * @param in: data  回应客户端数据的缓冲区首地址
 * @param in: dataLen: 回应客户端数据的长度
 * @param in: port 回应给客户端对应的路由port
 * @return :成功返回0 失败返回-1
 */
LIBACP_EXPORTS int libacpserver_send(msg_request req, uint16_t port, const char* data, uint32_t dataLen);

/**
 * @brief 释放ACP初始化的设备信息
 * @return :成功返回0,失败返回-1
 */
LIBACP_EXPORTS int libacpserver_finit();

#endif  // LIBACP_LIBACPSERVER_H_
